<?php
require_once 'config.php';
require_once 'header.php';
?>

<div class="hero-section text-center py-5">
    <h1 class="display-4 mb-4" style="font-weight:900;">
        أقوى لوحة <span class="smm-neon">SMM</span> في العالم العربي
    </h1>
    <p class="lead mb-4">خدمات التواصل الاجتماعي بأسعار منافسة وجودة عالية مع ضمان التنفيذ السريع</p>
    <div class="d-flex flex-column align-items-center gap-3">
        <div class="d-flex justify-content-center gap-3 mb-2">
            <a href="services.php" class="btn btn-primary btn-md">خدماتنا</a>
            <a href="contact.php" class="btn btn-outline-primary btn-md">تواصل معنا</a>
        </div>
        <div class="d-flex justify-content-center gap-2">
            <a href="login.php" class="btn btn-secondary btn-sm">تسجيل الدخول</a>
            <a href="register.php" class="btn btn-success btn-sm">إنشاء حساب</a>
        </div>
    </div>
</div>

<div class="py-5" style="background: #181c2f;">
    <div class="container text-center">
        <h2 class="mb-4" style="color: #fff;">استكشف طرق الدفع المتوفرة لدينا</h2>
        <p class="lead text-muted-white mb-5">نقدم لك خيارات دفع مرنة وآمنة لتسهيل إضافة الرصيد لحسابك.</p>
        <a href="payment-methods.php" class="btn btn-primary btn-lg">طرق الدفع</a>
    </div>
</div>

<div class="features-section py-5">
    <div class="row">
        <div class="col-md-4">
            <div class="card text-center">
                <div class="card-body">
                    <i class="bi bi-envelope-paper fs-1 text-primary mb-3"></i>
                    <h3>رسائل جماعية</h3>
                    <p>أرسل رسائل إلى مجموعة كبيرة من المستلمين بضغطة زر واحدة</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-center">
                <div class="card-body">
                    <i class="bi bi-graph-up fs-1 text-primary mb-3"></i>
                    <h3>تقارير تفصيلية</h3>
                    <p>احصل على تقارير مفصلة عن حالة الرسائل المرسلة</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-center">
                <div class="card-body">
                    <i class="bi bi-shield-check fs-1 text-primary mb-3"></i>
                    <h3>حماية متقدمة</h3>
                    <p>نظام حماية متقدم لضمان أمان رسائلك</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="pricing-section py-5">
    <h2 class="text-center mb-5">باقات الأسعار</h2>
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <h3 class="card-title">الباقة الأساسية</h3>
                    <p class="display-4 mb-4">100 $</p>
                    <ul class="list-unstyled mb-4">
                        <li>1000 رسالة</li>
                        <li>دعم فني</li>
                        <li>تقارير أساسية</li>
                    </ul>
                    <a href="register.php" class="btn btn-primary">اشترك الآن</a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <h3 class="card-title">الباقة المتقدمة</h3>
                    <p class="display-4 mb-4">250 $</p>
                    <ul class="list-unstyled mb-4">
                        <li>3000 رسالة</li>
                        <li>دعم فني متميز</li>
                        <li>تقارير متقدمة</li>
                    </ul>
                    <a href="register.php" class="btn btn-primary">اشترك الآن</a>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-body text-center">
                    <h3 class="card-title">الباقة الاحترافية</h3>
                    <p class="display-4 mb-4">500 $</p>
                    <ul class="list-unstyled mb-4">
                        <li>7000 رسالة</li>
                        <li>دعم فني على مدار الساعة</li>
                        <li>تقارير احترافية</li>
                    </ul>
                    <a href="register.php" class="btn btn-primary">اشترك الآن</a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.smm-neon {
    color: #00eaff;
    text-shadow: 0 0 8px #00eaff, 0 0 20px #00eaff, 0 0 40px #00eaff;
    font-weight: 900;
    letter-spacing: 2px;
}
</style>

<?php require_once 'footer.php'; ?> 